function T = dynamic_g2_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_g2_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 293);

T = World_Economy_Cartel_nonopec_shocks.dynamic_g1_tt(T, y, x, params, steady_state, it_);

T(257) = getPowerDeriv(T(9),T(10),3);
T(258) = T(156)+exp(y(13))*exp(y(13))*getPowerDeriv(exp(y(13)),params(3),2);
T(259) = T(5)*T(258);
T(260) = T(148)+T(147)+exp(y(37))*(T(146)+exp(y(37))*exp(y(37))*getPowerDeriv(exp(y(37)),T(11),3));
T(261) = y(57)*(-(T(81)*T(19)*T(16)*exp(T(1)*y(44))*(1-params(11))*params(3)*T(148)+T(5)*T(19)*T(83)*exp(T(1)*y(44))*(1-params(11))*params(3)*T(148)))+y(56)*(-(T(85)*T(3)*T(16)*exp(T(1)*y(44))*(1-params(11))*(1-params(3))*T(148)+T(17)*T(3)*T(83)*exp(T(1)*y(44))*(1-params(11))*(1-params(3))*T(148)));
T(262) = y(57)*(-(T(5)*T(19)*T(16)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(44))*T(148)))+y(56)*(-(T(17)*T(3)*T(16)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(44))*T(148)));
T(263) = T(159)+exp(y(13))*exp(y(13))*getPowerDeriv(exp(y(13)),params(3)-1,2);
T(264) = y(57)*(-(T(5)*(T(16)*T(52)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(44))*T(159)+T(19)*T(52)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(44))*T(82)*T(157))))+y(56)*(-(T(17)*(T(16)*T(52)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(44))*T(156)+T(3)*T(52)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(44))*T(82)*T(157))));
T(265) = y(57)*(-(T(81)*T(19)*T(53)*T(83)+T(19)*T(16)*T(53)*T(194)+T(81)*T(19)*T(53)*T(83)+T(5)*T(19)*T(53)*T(195)))+y(56)*(-(T(85)*T(3)*T(54)*T(83)+T(17)*T(3)*T(54)*T(195)+T(85)*T(3)*T(54)*T(83)+T(3)*T(16)*T(54)*T(199)));
T(266) = y(57)*(-(T(81)*T(19)*T(16)*T(52)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(44))+T(5)*T(19)*T(83)*T(52)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(44))))+y(56)*(-(T(17)*T(3)*T(83)*T(52)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(44))+T(85)*T(3)*T(16)*T(52)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(44))));
T(267) = y(57)*(-(T(5)*T(19)*T(16)*T(52)*(1-params(11))*params(3)*T(1)*T(1)*exp(T(1)*y(44))))+y(56)*(-(T(17)*T(3)*T(16)*T(52)*(1-params(11))*(1-params(3))*T(1)*T(1)*exp(T(1)*y(44))));
T(268) = getPowerDeriv(T(63),T(10),3);
T(269) = T(153)+exp(y(89))*exp(y(89))*getPowerDeriv(exp(y(89)),T(11),2);
T(270) = (1-params(11))*(1-params(3))*exp(T(1)*y(94))*T(269);
T(271) = T(172)+T(171)+T(20)*(T(170)+T(20)*T(20)*getPowerDeriv(T(20),params(3),3));
T(272) = getPowerDeriv(T(59),T(1),3);
T(273) = getPowerDeriv(T(59),T(13),3);
T(274) = T(56)*T(172)*T(56)*T(57)*T(175)+T(69)*T(56)*T(271)+T(56)*T(172)*T(56)*T(57)*T(175)+T(56)*T(57)*(T(56)*T(172)*T(175)+T(56)*T(57)*T(56)*T(57)*T(273));
T(275) = T(56)*T(172)*T(175)*T(58)*T(211)+T(69)*T(172)*T(211)+T(56)*T(57)*T(175)*T(57)*T(211)+T(56)*T(57)*(T(175)*T(57)*T(211)+T(56)*T(57)*T(58)*T(211)*T(273));
T(276) = T(211)+exp(y(90))*exp(y(90))*getPowerDeriv(exp(y(90)),1-params(3),2);
T(277) = T(57)*T(211)*T(175)*T(58)*T(211)+T(69)*T(57)*T(276)+T(57)*T(211)*T(175)*T(58)*T(211)+T(56)*T(57)*(T(58)*T(211)*T(58)*T(211)*T(273)+T(175)*T(58)*T(276));
T(278) = getPowerDeriv(T(6),T(13),3);
T(279) = T(81)*T(156)*T(157)*T(162)+T(82)*T(81)*T(258)+T(81)*T(156)*T(157)*T(162)+T(3)*T(81)*(T(162)*T(259)+T(157)*T(157)*T(278));
T(280) = getPowerDeriv(T(6),T(1),3);
T(281) = getPowerDeriv(T(27),(-params(14)),2);
T(282) = T(182)*(-(params(9)*(T(180)+exp(y(14))*exp(y(14))*getPowerDeriv(exp(y(14)),1+params(8),2))/(1+params(8))))+T(181)*T(181)*T(281);
T(283) = T(28)*exp(y(15))*T(182)+T(28)*exp(y(15))*T(182);
T(284) = getPowerDeriv(T(25),(-params(14)),3);
T(285) = T(189)*T(76)*T(190)+T(77)*(-(params(9)*(T(188)+T(187)+T(4)*(T(186)+T(4)*T(4)*getPowerDeriv(T(4),1+params(8),3)))/(1+params(8))))+T(189)*T(76)*T(190)+T(76)*(T(189)*T(190)+T(76)*T(76)*T(284));
T(286) = T(194)+T(193)+T(4)*(T(192)+T(4)*T(4)*getPowerDeriv(T(4),1-params(3),3));
T(287) = T(3)*T(194)*T(3)*T(81)*T(162)+T(82)*T(3)*T(286)+T(3)*T(194)*T(3)*T(81)*T(162)+T(3)*T(81)*(T(162)*T(3)*T(194)+T(3)*T(81)*T(3)*T(81)*T(278));
T(288) = getPowerDeriv(T(89),(-params(14)),2);
T(289) = params(1)*(T(217)*(-(params(9)*(T(215)+exp(y(90))*exp(y(90))*getPowerDeriv(exp(y(90)),1+params(8),2))/(1+params(8))))+T(216)*T(216)*T(288));
T(290) = y(57)*(-(T(81)*T(19)*T(16)*T(12)*(1-params(11))*params(3)*T(1)*T(1)*exp(T(1)*y(44))+T(5)*T(19)*T(83)*T(12)*(1-params(11))*params(3)*T(1)*T(1)*exp(T(1)*y(44))));
T(291) = y(56)*(-(T(85)*T(3)*T(16)*T(12)*(1-params(11))*(1-params(3))*T(1)*T(1)*exp(T(1)*y(44))+T(17)*T(3)*T(83)*T(12)*(1-params(11))*(1-params(3))*T(1)*T(1)*exp(T(1)*y(44))));
T(292) = T(224)+exp(y(40))*exp(y(40))*T(190)+exp(y(40))*(exp(y(40))*T(190)+exp(y(40))*exp(y(40))*T(284));
T(293) = getPowerDeriv(exp(y(53)-y(45)),params(5)-1,3);

end
